"use strict";(globalThis.webpackChunk_plex_client_qt=globalThis.webpackChunk_plex_client_qt||[]).push([["packages_visualizer_shaders_dancers_glsl"],{26471:e=>{e.exports="#extension GL_OES_standard_derivatives : enable\n\nprecision mediump float;\n\nuniform float uTime;\nuniform vec2 uResolution;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nuniform sampler2D uSampler;\n\n/*--------------------------------------------------------------------------------------\nLicense CC0 - http://creativecommons.org/publicdomain/zero/1.0/\nTo the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.\n----------------------------------------------------------------------------------------\n^ This means do ANYTHING YOU WANT with this code. Because we are programmers, not lawyers.\n-Otavio Good\n*/\n\n#define saturate(a) clamp(a, 0.0, 1.0)  // Clamp [0..1] range\n\n// Got this line drawing function from https://www.shadertoy.com/view/4tc3DX\n// This function will make a signed distance field that says how far you are from the edge\n// of the line at any point U,V.\n// Pass it UVs, line end points, line thickness (x is along the line and y is perpendicular),\n// How rounded the end points should be (0.0 is rectangular, setting rounded to thick.y will be circular),\n// dashOn is just 1.0 or 0.0 to turn on the dashed lines.\nfloat LineDistField(vec2 uv, vec2 pA, vec2 pB, vec2 thick, float rounded) {\n    // Don't let it get more round than circular.\n    //thick = vec2(0.005, 0.005);\n    rounded = min(thick.y, rounded);\n    // midpoint\n    vec2 mid = (pB + pA) * 0.5;\n    // vector from point A to B\n    vec2 delta = pB - pA;\n    // Distance between endpoints\n    float lenD = length(delta);\n    // unit vector pointing in the line's direction\n    vec2 unit = delta / lenD;\n    // Check for when line endpoints are the same\n    if (lenD < 0.0001) unit = vec2(1.0, 0.0);    // if pA and pB are same\n    // Perpendicular vector to unit - also length 1.0\n    vec2 perp = unit.yx * vec2(-1.0, 1.0);\n    // position along line from midpoint\n    float dpx = dot(unit, uv - mid);\n    // distance away from line at a right angle\n    float dpy = dot(perp, uv - mid);\n    // Make a distance function that is 0 at the transition from black to white\n    float disty = abs(dpy) - thick.y + rounded;\n    float distx = abs(dpx) - lenD * 0.5 - thick.x + rounded;\n\n    // Too tired to remember what this does. Something like rounded endpoints for distance function.\n    float dist = length(vec2(max(0.0, distx), max(0.0,disty))) - rounded;\n    dist = min(dist, max(distx, disty));\n\n    return dist;\n}\n\n// This makes a line in UV units. A 1.0 thick line will span a whole 0..1 in UV space.\nfloat FillLine(vec2 uv, vec2 pA, vec2 pB, vec2 thick, float rounded) {\n    float df = LineDistField(uv, pA, pB, vec2(thick), rounded);\n    return saturate(df / abs(dFdy(uv).y));\n}\n\nfloat Wobble(float a, float seed) {\n    //seed = floor(seed) * 3.14159 * 0.5;\n    a += seed;\n    return sin(a) + sin(a * 2.0)*0.5 + sin(a * 4.0)*0.25;\n}\n\n// makes a dancer in the 0..1 uv space. Seed is which dancer to draw.\nfloat Dancer(vec2 uv, vec2 seed)\n{\n    float time = uTime*4.0;\n\n    float legLen = 0.18;\n    float armLen = 0.15;\n\n    // Define joint positions\n    vec2 hipA = vec2(0.57,0.33);\n    vec2 kneeA = vec2(0.65 + Wobble(time, seed.x*7.6543)*0.1, 0.2);\n    vec2 footA = vec2(0.6 + Wobble(time, seed.x*237.6543)*0.1, 0.0);\n    // Constrain joints to be a fixed length\n    kneeA = normalize(kneeA - hipA) * legLen + hipA;\n    footA = normalize(footA - kneeA) * legLen + kneeA;\n\n    vec2 hipB = vec2(0.43,0.33);\n    vec2 kneeB = vec2(0.35 + Wobble(time, seed.x*437.6543)*0.1, 0.2);\n    vec2 footB = vec2(0.4 + Wobble(time, seed.x*383.6543)*0.1, 0.0);\n    kneeB = normalize(kneeB - hipB) * legLen + hipB;\n    footB = normalize(footB - kneeB) * legLen + kneeB;\n\n    vec2 shoulderA = vec2(0.62, 0.67);\n    vec2 elbowA = vec2(0.8, 0.43 + Wobble(time, seed.x*7.6543)*0.3);\n    vec2 handA = elbowA + vec2(.14, 0.0 + Wobble(time, seed.x*73.6543)*0.5);\n    elbowA = normalize(elbowA - shoulderA) * armLen + shoulderA;\n    handA = normalize(handA - elbowA) * armLen + elbowA;\n\n    vec2 shoulderB = vec2(0.38, 0.67);\n    vec2 elbowB = vec2(0.2, 0.43 + Wobble(time, seed.x*17.6543)*0.3);\n    vec2 handB = elbowB + vec2(-0.14, 0.0 + Wobble(time, seed.x*173.6543)*0.5);\n    elbowB = normalize(elbowB - shoulderB) * armLen + shoulderB;\n    handB = normalize(handB - elbowB) * armLen + elbowB;\n\n    vec2 headPos = vec2(0.5 + Wobble(time, seed.x*573.6543)*0.03, 0.83 + sin(time*2.0)* 0.01);\n\n    // Find an approximate center of mass on the x axis\n    float balance = (kneeA.x + kneeB.x + footA.x + footB.x +\n                    elbowA.x + elbowB.x + handA.x + handB.x +\n                    headPos.x * 1.0) - (0.5*9.0);\n\n    // Make the dancer stick to the ground even when they lift their legs.\n    float ground = min(footA.y, footB.y);\n    uv.y += ground - 0.025;\n    // Make them counter-balance based on approximate center of mass\n    uv.x += balance*0.3;\n\n    // Torso\n    float l = max(0.0, FillLine(uv, vec2(0.5,0.45), vec2(0.5,0.6), vec2(0.12,0.12), 0.0));\n\n    // Legs\n    l = min(l, FillLine(uv, kneeA, hipA, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, kneeA, footA, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, kneeB, hipB, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, kneeB, footB, vec2(0.05,0.05), 1.0));\n\n    // Arms\n    l = min(l, FillLine(uv, elbowA, shoulderA, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, elbowA, handA, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, elbowB, shoulderB, vec2(0.05,0.05), 1.0));\n    l = min(l, FillLine(uv, elbowB, handB, vec2(0.05,0.05), 1.0));\n\n    // Head\n    l = min(l, FillLine(uv, headPos, headPos, vec2(0.1,0.1), 1.0));\n\n    // Optional skirt\n    if (fract(seed.x*123.4567) > 0.5) {\n        l = min(l, FillLine(uv, vec2(0.5, 0.55), vec2(0.65, 0.33), vec2(0.05,0.05), 1.0));\n        l = min(l, FillLine(uv, vec2(0.5, 0.55), vec2(0.35, 0.33), vec2(0.05,0.05), 1.0));\n        l = min(l, FillLine(uv, vec2(0.35, 0.33), vec2(0.65, 0.33), vec2(0.05,0.05), 1.0));\n    }\n\n    return l;\n}\n\n#define START_FREQ 0.0\n#define END_FREQ 0.05\n#define FREQ_INTERVAL 0.0005\n\nfloat getAverageIntensity() {\n  float sum = 0.;\n  float count = 0.;\n\n  for (float i = START_FREQ; i <= END_FREQ; i += FREQ_INTERVAL) {\n    sum += texture2D(uSampler, vec2(i, 0.0)).x;\n    count += 1.;\n  }\n\n  return pow(sum / count, 3.);\n}\n\n//  Function from Iñigo Quiles\n//  https://www.shadertoy.com/view/MsS3Wc\nvec3 hsb2rgb( in vec3 c ){\n    vec3 rgb = clamp(abs(mod(c.x*6.0+vec3(0.0,4.0,2.0), 6.0)-3.0)-1.0, 0.0, 1.0 );\n    rgb = rgb*rgb*(3.0-2.0*rgb);\n    return c.z * mix(vec3(1.0), rgb, c.y);\n}\n\nvoid main( void )\n{\n    vec2 uv = vec2(vTextureCoord.x, 1.-vTextureCoord.y);\n    uv.x *= uResolution.x / uResolution.y;\n    uv.x += uTime * 0.05;    // scroll left with time\n\n    // make a grid for drawing.\n    uv *= 3.0;// * (sign(iMouse.z) + 2.0);\n    uv.y *= 0.8;\n    uv.y += 0.3;\n    vec2 newSeed = floor(uv);\n\n    // Make those dancing people!\n    vec2 dancerUv = fract(uv);\n    float finalLine = Dancer(fract(uv), newSeed-0.41);\n    finalLine *= mod(newSeed.y, 2.0);  // the mod kills every other line.\n\n    float lseed = length(newSeed);\n    float intensity = getAverageIntensity();\n    vec3 colorHsb = vec3(\n        cos(lseed * 583.)+uTime*0.00132148,\n        1.0,\n        max((1.-distance(dancerUv, vec2(0.5,0.1))) * 2. * intensity, .05)\n    );\n    vec3 backColor = hsb2rgb(colorHsb);\n    vec3 finalColor = backColor * finalLine;\n\n    gl_FragColor = vec4(finalColor,1.0);\n}\n"}}]);